import mods.jei.JEI;
import crafttweaker.api.item.IItemStack;

#Ores

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:lead_ore>) {
    tag.remove(<item:mekanism:lead_ore>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:mekanism:lead_ore>) {
    tag.remove(<block:mekanism:lead_ore>);
}
for tag in <tagManager:items>.getTagsFor(<item:mekanism:deepslate_lead_ore>) {
    tag.remove(<item:mekanism:deepslate_lead_ore>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:mekanism:deepslate_lead_ore>) {
    tag.remove(<block:mekanism:deepslate_lead_ore>);
}

mods.jei.JEI.hideIngredient(<item:mekanism:lead_ore>);
mods.jei.JEI.hideIngredient(<item:mekanism:deepslate_lead_ore>);
mods.jei.JEI.hideIngredient(<item:ae2:facade>.withTag({item: "mekanism:lead_ore" as string}));
mods.jei.JEI.hideIngredient(<item:ae2:facade>.withTag({item: "mekanism:deepslate_lead_ore" as string}));

<recipetype:mekanism:combining>.removeByName("mekanism:processing/lead/ore/from_raw");
<recipetype:mekanism:combining>.removeByName("mekanism:processing/lead/ore/deepslate_from_raw");

<recipetype:mekanism:combining>.addJsonRecipe("processing_lead_ore_from_raw", {
    "mainInput": {
        "amount": 8,
        "ingredient": {
            "tag": "forge:raw_materials/lead"
        }
    },
    "extraInput": {
        "ingredient": {
            "tag": "forge:cobblestone/normal"
        }
    },
    "output": {
        "item": "immersiveengineering:ore_lead"
    }
});
<recipetype:mekanism:combining>.addJsonRecipe("processing_lead_ore_deepslate_from_raw", {
    "mainInput": {
        "amount": 8,
        "ingredient": {
            "tag": "forge:raw_materials/lead"
        }
    },
    "extraInput": {
        "ingredient": {
            "tag": "forge:cobblestone/deepslate"
        }
    },
    "output": {
        "item": "immersiveengineering:deepslate_ore_lead"
    }
});

#Thermal
for tag in <tagManager:items>.getTagsFor(<item:thermal:lead_ore>) {
    tag.remove(<item:thermal:lead_ore>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:thermal:lead_ore>) {
    tag.remove(<block:thermal:lead_ore>);
}
for tag in <tagManager:items>.getTagsFor(<item:thermal:deepslate_lead_ore>) {
    tag.remove(<item:thermal:deepslate_lead_ore>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:thermal:deepslate_lead_ore>) {
    tag.remove(<block:thermal:deepslate_lead_ore>);
}

mods.jei.JEI.hideIngredient(<item:thermal:lead_ore>);
mods.jei.JEI.hideIngredient(<item:thermal:deepslate_lead_ore>);


#Raw Ores

#Thermal
for tag in <tagManager:items>.getTagsFor(<item:thermal:raw_lead>) {
    tag.remove(<item:thermal:raw_lead>);
}

mods.jei.JEI.hideIngredient(<item:thermal:raw_lead>);

<recipetype:cyclic:crusher>.remove(<item:thermal:raw_lead>);
<recipetype:thermal:press>.remove(<item:thermal:raw_lead>);
<recipetype:minecraft:crafting>.removeByName('thermal:storage/raw_lead_from_block');

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:raw_lead>) {
    tag.remove(<item:mekanism:raw_lead>);
}

mods.jei.JEI.hideIngredient(<item:mekanism:raw_lead>);

<recipetype:minecraft:crafting>.remove(<item:mekanism:raw_lead>);
<recipetype:cyclic:crusher>.remove(<item:mekanism:raw_lead>);


#Immersive
<recipetype:cyclic:crusher>.remove(<item:immersiveengineering:raw_lead>);

<recipetype:cyclic:crusher>.addJsonRecipe('lead_ore_to_raw', {
    "input": {
        "tag": "forge:ores/lead"
    },
    "energy": {
        "ticks": 600,
        "rfpertick": 60
    },
    "result": {
        "item": "immersiveengineering:raw_lead",
        "count": 3
    },
    "percent": 75,
    "bonus": {
        "item": "thermal:lead_nugget",
        "count": 9
    }
});
<recipetype:thermal:press>.addJsonRecipe('press_raw_lead_from_block', {
    "ingredients": [
        {
            "tag": "forge:storage_blocks/raw_lead",
        },
        {
            "item": "thermal:press_unpacking_die"
        }
    ],
    "result": [
        {
            "item": "immersiveengineering:raw_lead",
            "count": 9
        }
    ],
    "energy": 400
});

#Raw Ore Blocks

#Thermal
for tag in <tagManager:items>.getTagsFor(<item:thermal:raw_lead_block>) {
    tag.remove(<item:thermal:raw_lead_block>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:thermal:raw_lead_block>) {
    tag.remove(<block:thermal:raw_lead_block>);
}

mods.jei.JEI.hideIngredient(<item:thermal:raw_lead_block>);
mods.jei.JEI.hideIngredient(<item:ae2:facade>.withTag({item: "thermal:raw_lead_block" as string}));

<recipetype:minecraft:crafting>.remove(<item:thermal:raw_lead_block>);
<recipetype:thermal:press>.remove(<item:thermal:raw_lead_block>);


<recipetype:thermal:press>.addJsonRecipe('press_raw_lead_block', {
    "ingredients": [
        {
            "tag": "forge:raw_materials/lead",
            "count": 9
        },
        {
            "item": "thermal:press_packing_3x3_die"
        }
    ],
    "result": [
        {
            "item": "immersiveengineering:raw_block_lead"
        }
    ],
    "energy": 400
});

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:block_raw_lead>) {
    tag.remove(<item:mekanism:block_raw_lead>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:mekanism:block_raw_lead>) {
    tag.remove(<block:mekanism:block_raw_lead>);
}


mods.jei.JEI.hideIngredient(<item:mekanism:block_raw_lead>);
mods.jei.JEI.hideIngredient(<item:ae2:facade>.withTag({item: "mekanism:block_raw_lead" as string}));

<recipetype:minecraft:crafting>.remove(<item:mekanism:block_raw_lead>);

#Crushed Ore
mods.jei.JEI.hideIngredient(<item:create:crushed_lead_ore>);

<recipetype:thermal:centrifuge>.removeByName("thermal:compat/create/centrifuge_create_crushed_lead_ore");
<recipetype:thermal:smelter>.remove(<item:thermal:lead_ingot>);
<recipetype:create:crushing>.remove(<item:create:crushed_lead_ore>);

<recipetype:thermal:centrifuge>.addJsonRecipe("crushed_lead_ore_to_nuggets", {
    "ingredient": {
        "item": "jaopca:create_crushed_ores.lead"
    },
    "result": [
        {
            "item": "thermal:lead_nugget",
            "count": 9
        },
        {
            "item": "thermal:silver_nugget",
            "chance": 0.25
        }
    ],
    "energy": 1600
});
<recipetype:thermal:smelter>.addJsonRecipe("crushed_lead_ore_to_ingot", {
    "ingredient": {
        "item": "jaopca:create_crushed_ores.lead"
    },
    "result": [
        {
            "item": "thermal:lead_ingot"
        }
    ],
    "energy": 1600
});

#Dust

#Immersive
for tag in <tagManager:items>.getTagsFor(<item:immersiveengineering:dust_lead>) {
    tag.remove(<item:immersiveengineering:dust_lead>);
}

<recipetype:minecraft:crafting>.remove(<item:immersiveengineering:dust_lead>);

mods.jei.JEI.hideIngredient(<item:immersiveengineering:dust_lead>);

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:dust_lead>) {
    tag.remove(<item:mekanism:dust_lead>);
}

mods.jei.JEI.hideIngredient(<item:mekanism:dust_lead>);

<recipetype:mekanism:crushing>.removeByName('mekanism:processing/lead/dust/from_ingot');
<recipetype:mekanism:enriching>.removeByName('mekanism:processing/lead/dust/from_dirty_dust');
<recipetype:mekanism:enriching>.removeByName('mekanism:processing/lead/dust/from_ore');
<recipetype:mekanism:enriching>.removeByName('mekanism:processing/lead/dust/from_raw_block');
<recipetype:mekanism:enriching>.removeByName('mekanism:processing/lead/dust/from_raw_ore');

<recipetype:mekanism:crushing>.addJsonRecipe('lead_dust_from_ingot', {
    "input": {
        "ingredient": {
            "tag": "forge:ingots/lead"
        }
    },
    "output": {
        "item": "thermal:lead_dust"
    }
});
<recipetype:mekanism:crushing>.addJsonRecipe('lead_dust_from_dirty_dust', {
    "input": {
        "ingredient": {
            "tag": "mekanism:dirty_dusts/lead"
        }
    },
    "output": {
        "item": "thermal:lead_dust"
    }
});
<recipetype:mekanism:crushing>.addJsonRecipe('lead_dust_from_ore', {
    "input": {
        "ingredient": {
            "tag": "forge:ores/lead"
        }
    },
    "output": {
        "item": "thermal:lead_dust",
        "count": 2
    }
});
<recipetype:mekanism:crushing>.addJsonRecipe('lead_dust_from_raw_block', {
    "input": {
        "ingredient": {
            "tag": "forge:storage_blocks/raw_lead"
        }
    },
    "output": {
        "item": "thermal:lead_dust",
        "count": 12
    }
});
<recipetype:mekanism:crushing>.addJsonRecipe('lead_dust_from_raw_ore', {
    "input": {
    "amount": 3,
        "ingredient": {
            "tag": "forge:raw_materials/lead"
        }
    },
    "output": {
        "item": "thermal:lead_dust",
        "count": 4
    }
});
craftingTable.addShapeless("crafting_hammercrushing_lead", <item:thermal:lead_dust>, [
    <tag:items:forge:ores/lead>, <item:immersiveengineering:hammer>.anyDamage().transformDamage()
]);
craftingTable.addShapeless("crafting_raw_hammercrushing_lead", <item:thermal:lead_dust>, [
    <tag:items:forge:raw_materials/lead>, <item:immersiveengineering:hammer>.anyDamage().transformDamage()
]);

#Blocks

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:block_lead>) {
    tag.remove(<item:mekanism:block_lead>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:mekanism:block_lead>) {
    tag.remove(<block:mekanism:block_lead>);
}

mods.jei.JEI.hideIngredient(<item:mekanism:block_lead>);

<recipetype:minecraft:crafting>.remove(<item:mekanism:block_lead>);

#Thermal
for tag in <tagManager:items>.getTagsFor(<item:thermal:lead_block>) {
    tag.remove(<item:thermal:lead_block>);
}
for tag in <tagManager:blocks>.getTagsFor(<block:thermal:lead_block>) {
    tag.remove(<block:thermal:lead_block>);
}

mods.jei.JEI.hideIngredient(<item:thermal:lead_block>);

<recipetype:minecraft:crafting>.remove(<item:thermal:lead_block>);
<recipetype:thermal:press>.remove(<item:thermal:lead_block>);

<recipetype:thermal:press>.addJsonRecipe('press_lead_block', {
    "ingredients": [
        {
            "tag": "forge:ingots/lead",
            "count": 9
        },
        {
            "item": "thermal:press_packing_3x3_die"
        }
    ],
    "result": [
        {
            "item": "immersiveengineering:storage_lead"
        }
    ],
    "energy": 400
});

#Ingots

#Immersive
for tag in <tagManager:items>.getTagsFor(<item:immersiveengineering:ingot_lead>) {
    tag.remove(<item:immersiveengineering:ingot_lead>);
}

mods.jei.JEI.hideIngredient(<item:immersiveengineering:ingot_lead>);

<recipetype:minecraft:crafting>.remove(<item:immersiveengineering:ingot_lead>);
<recipetype:minecraft:smelting>.remove(<item:immersiveengineering:ingot_lead>);
<recipetype:minecraft:blasting>.remove(<item:immersiveengineering:ingot_lead>);
<recipetype:thermal:chiller>.remove(<item:immersiveengineering:ingot_lead>);
<recipetype:minecraft:crafting>.removeByName('immersiveengineering:crafting/ingot_lead_to_storage_lead');

craftingTable.addShaped("lead_block_from_ingots", <item:immersiveengineering:storage_lead>,
    [[<tag:items:forge:ingots/lead>,<tag:items:forge:ingots/lead>,<tag:items:forge:ingots/lead>],
     [<tag:items:forge:ingots/lead>,<tag:items:forge:ingots/lead>,<tag:items:forge:ingots/lead>],
     [<tag:items:forge:ingots/lead>,<tag:items:forge:ingots/lead>,<tag:items:forge:ingots/lead>]]
);

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:ingot_lead>) {
    tag.remove(<item:mekanism:ingot_lead>);
}

mods.jei.JEI.hideIngredient(<item:mekanism:ingot_lead>);

<recipetype:minecraft:crafting>.remove(<item:mekanism:ingot_lead>);
<recipetype:minecraft:smelting>.remove(<item:mekanism:ingot_lead>);
<recipetype:minecraft:blasting>.remove(<item:mekanism:ingot_lead>);
<recipetype:thermal:smelter>.remove(<item:mekanism:ingot_lead>);

#Ex Nihilo
for tag in <tagManager:items>.getTagsFor(<item:exnihilosequentia:lead_ingot>) {
    tag.remove(<item:exnihilosequentia:lead_ingot>);
}

mods.jei.JEI.hideIngredient(<item:exnihilosequentia:lead_ingot>);

<recipetype:minecraft:smelting>.remove(<item:exnihilosequentia:lead_ingot>);
<recipetype:minecraft:blasting>.remove(<item:exnihilosequentia:lead_ingot>);
<recipetype:thermal:chiller>.remove(<item:exnihilosequentia:lead_ingot>);

#Thermal
<recipetype:minecraft:smelting>.remove(<item:thermal:lead_ingot>);
<recipetype:minecraft:blasting>.remove(<item:thermal:lead_ingot>);
<recipetype:minecraft:crafting>.remove(<item:thermal:lead_ingot>);

craftingTable.addShaped("lead_ingot_from_nuggets", <item:thermal:lead_ingot>,
    [[<tag:items:forge:nuggets/lead>,<tag:items:forge:nuggets/lead>,<tag:items:forge:nuggets/lead>],
     [<tag:items:forge:nuggets/lead>,<tag:items:forge:nuggets/lead>,<tag:items:forge:nuggets/lead>],
     [<tag:items:forge:nuggets/lead>,<tag:items:forge:nuggets/lead>,<tag:items:forge:nuggets/lead>]]
);
craftingTable.addShapeless("lead_ingots_from_block", <item:thermal:lead_ingot>*9,
    [<item:immersiveengineering:storage_lead>]
);

furnace.addRecipe('crushed_lead_ore_smelting_ingot',
    <item:thermal:lead_ingot>, <item:jaopca:create_crushed_ores.lead>, 0.1, 200
);
furnace.addRecipe('lead_dust_smelting_ingot',
    <item:thermal:lead_ingot>, <item:thermal:lead_dust>, 0.0, 200
);
furnace.addRecipe('lead_ore_smelting_ingot',
    <item:thermal:lead_ingot>, <tag:items:forge:ores/lead>, 0.8, 200
);
furnace.addRecipe('raw_lead_ore_smelting_ingot',
    <item:thermal:lead_ingot>, <item:immersiveengineering:raw_lead>, 0.7, 200
);
blastFurnace.addRecipe('crushed_lead_ore_blasting_ingot',
    <item:thermal:lead_ingot>, <item:jaopca:create_crushed_ores.lead>, 0.1, 100
);
blastFurnace.addRecipe('lead_dust_blasting_ingot',
    <item:thermal:lead_ingot>, <item:thermal:lead_dust>, 0.0, 100
);
blastFurnace.addRecipe('lead_ore_blasting_ingot',
    <item:thermal:lead_ingot>, <tag:items:forge:ores/lead>, 0.8, 100
);
blastFurnace.addRecipe('raw_lead_ore_blasting_ingot',
    <item:thermal:lead_ingot>, <item:immersiveengineering:raw_lead>, 0.7, 100
);

#Nuggets

#Immersive
for tag in <tagManager:items>.getTagsFor(<item:immersiveengineering:nugget_lead>) {
    tag.remove(<item:immersiveengineering:nugget_lead>);
}

mods.jei.JEI.hideIngredient(<item:immersiveengineering:nugget_lead>);


<recipetype:minecraft:crafting>.remove(<item:immersiveengineering:nugget_lead>);
<recipetype:create:splashing>.remove(<item:immersiveengineering:nugget_lead>);
<recipetype:thermal:centrifuge>.removeByName("jaopca:thermal_expansion.create_crushed_ore_to_nugget.lead");

#Mekanism
for tag in <tagManager:items>.getTagsFor(<item:mekanism:nugget_lead>) {
    tag.remove(<item:mekanism:nugget_lead>);
}

mods.jei.JEI.hideIngredient(<item:mekanism:nugget_lead>);

<recipetype:minecraft:crafting>.remove(<item:mekanism:nugget_lead>);
<recipetype:create:splashing>.remove(<item:mekanism:nugget_lead>);

#Thermal
<recipetype:create:splashing>.remove(<item:thermal:lead_nugget>);
<recipetype:create:splashing>.addRecipe("splashing_crushed_lead_ore_to_nuggets",
    [<item:thermal:lead_nugget> * 9 % 100], <item:jaopca:create_crushed_ores.lead>
);

#Plate
for tag in <tagManager:items>.getTagsFor(<item:immersiveengineering:plate_lead>) {
    tag.remove(<item:immersiveengineering:plate_lead>);
}

mods.jei.JEI.hideIngredient(<item:immersiveengineering:plate_lead>);

<recipetype:minecraft:crafting>.remove(<item:immersiveengineering:plate_lead>);
<recipetype:create:pressing>.remove(<item:immersiveengineering:plate_lead>);

craftingTable.addShapeless("hammering_lead_to_plate",
    <item:thermal:lead_plate>, [<tag:items:forge:ingots/lead>, <item:immersiveengineering:hammer>.anyDamage().transformDamage()]
);
<recipetype:create:pressing>.addRecipe("create_pressing_lead_ingot_to_plate",
    [<item:thermal:lead_plate> % 100.0], <tag:items:forge:ingots/lead>
);